******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close

***************************
* Generate and clean data *	
***************************

*Combine data from various sources
use "$external_dir\Data\external_data\hurricane_index.dta", clear
keep if year>=1980 & year<=2004

	*Merge in IPUMS data
	merge 1:1 country_str year using "$external_dir\Data\ipums_usa.dta"
	drop _merge

	*Merge in DHS LPR data
	merge 1:1 country_str year using "$external_dir\Data\external_data\dhs_lpr_final.dta"
	drop _merge

	*Merge in DHS non-imm data
	merge 1:1 country_str year using "$external_dir\Data\external_data\dhs_nonimmi_final.dta"
	drop _merge

	*Merge in populations
	merge m:1 country_str using "$external_dir\Data\external_data\populations.dta"
	drop _merge
	rename population pop1980

*Drop countries & years not in final sample 
drop if country_str=="Albania" | country_str=="Armenia" | country_str=="Austria" | ///
	country_str=="Azerbaijan" | country_str=="Belarus" | country_str=="Belgium" | ///
	country_str=="Bosnia and Herzegovina" | country_str=="Bulgaria" | ///
	country_str=="Czech Republic" | country_str=="Denmark" | ///
	country_str=="Estonia" | country_str=="Finland" | country_str=="France" | ///
	country_str=="Georgia" | country_str=="Germany" | country_str=="Gibraltar" | ///
	country_str=="Greece" | country_str=="Greenland" | ///
	country_str=="Holy See (Vatican City)" | country_str=="Hungary" | country_str=="Iceland" | ///
	country_str=="Ireland" | country_str=="Isle of Man" | country_str=="Italy" | ///
	country_str=="Jersey" | country_str=="Korea (the Democratic Republic of)" | ///
	country_str=="Korea, Democratic Republic of" | country_str=="Latvia" | ///
	country_str=="Liechtenstein" | country_str=="Lithuania" | country_str=="Luxembourg" | ///
	country_str=="Malta" | country_str=="Montenegro" | country_str=="Oceania" | ///
	country_str=="Other Oceania" | country_str=="Poland" | country_str=="Puerto Rico" | ///
	country_str=="Republic of Moldova" | country_str=="Romania" | country_str=="Saint Martin" | ///
	country_str=="Slovakia" | country_str=="Slovenia" | country_str=="Spain" | ///
	country_str=="Svalbard" | country_str=="Sweden" | country_str=="Switzerland" | ///
	country_str=="Tajikistan" | country_str=="The former Yugoslav Republic of Macedonia" | ///
	country_str=="Turkmenistan" | country_str=="Ukraine" | country_str=="United Kingdom" | ///
	country_str=="United States Virgin Islands" | country_str=="United States of America (the)" | ///
	country_str=="Virgin Island (U.S.)" | country_str=="Bosnia-Herzegovina" | ///
	country_str=="Christmas Island" | country_str=="Cocos Islands" | ///
	country_str=="Guernsey" | country_str=="Korea, Democratic People's Republic of" | ///
	country_str=="Marshall Islands" | country_str=="Monaco" | country_str=="Macedonia" | ///
	country_str=="Netherlands" | country_str=="Norfolk Island" | ///
	country_str=="Russia" | country_str=="San Marino" | country_str=="Moldova" | ///
	country_str=="Aaland Islands" | country_str=="Faroe Islands" | ///
	country_str=="Northern Mariana Islands" | strpos(country_str,"Antarctic") | ///
	country_str=="Norway" | country_str=="Guam" | country_str=="Holy See" | ///
	country_str=="Portugal" | country_str=="Gaza Strip" | ///
	country_str=="Serbia" | country_str=="Croatia" | country_str=="Palestine" | ///
	country_str=="Pitcairn Islands" | country_str=="Kyrgyzstan" | country_str=="Oceania" | ///
	country_str=="Kazakhstan" | country_str=="Uzbekistan" | country_str=="American Samoa" | ///
	country_str=="Andorra" | country_str=="Eritrea" | country_str=="Mayotte" | ///
	country_str=="Palau" | country_str=="Saint Pierre and Miquelon" | country_str=="Tuvalu" | ///
	strpos(country_str,"Miquelon") | strpos(country_str,"Democratic People's") | country_str=="Korea, North" | ///
	country_str=="Pacific Island Trust Territory" | country_str=="Serbia-Montenegro" | ///
	country_str=="Western Samoa" | country_str=="Yugoslavia" | strpos(country_str,"Oceania") | ///
	country_str=="Nice" || country_str==""
keep if year>=1980 & year<=2004
sort country year


*************************
* Generate Tables 1 & 2 *
*************************

*Variables
format country_str %15s
gen p_migrants = migrants/pop1980
gen p_stock = stock1980/pop1980
gen p_stock_cit = stock_cit1980/pop1980
gen p_stock_noncit = stock_noncit1980/pop1980
gen p_immigrants = (total-irca)/pop1980
gen p_non_immigrants = TOT_2e/pop1980
gen p_immediate = immediate/pop1980
gen p_family = (immediate+family_sponsored)/pop1980
gen HI_ifg0 = HI if HI>0

*Summary Statistics
local vars "HI HI_ifg0 pop1980 p_migrants p_immigrants p_non_immigrants p_immediate p_family p_stock p_stock_cit p_stock_noncit"
tabstat `vars', stats(mean sd p10 p25 p50 p75 p90 N) c(s) save

*Save to matrix
mat A = r(StatTotal)
mat list A

*Generate additional row with number of countries represented 
local bsize = 0
foreach var in `vars' {
	local bsize = `bsize'+1
	}
mat B = J(1,`bsize',.)
local i = 1
foreach var in `vars' {
	tab country_str if `var'!=.
	mat B[1,`i']=r(r)
	local i = `i'+1
	}
mat list B

*Append this row
mat C = [A\B]
mat list C

*Country list -- TABLE 1
label var country_str "Country"
preserve
	bysort country_str: gen n = _n
	keep if n==1
	keep country_str
	export excel using "$external_dir\Output\table1.xlsx", replace first(varl)
restore

*Save summary statistic table -- TABLE 2 (transposed) 
putexcel set "$external_dir\Output\table2.xlsx", replace
putexcel A1=matrix(C), names
